/* 
	An Android application to retrieve text off a webserver and update the UI display
	based on a start button click. URL is hardcoded in. Currently implemented through
	an asynchronous task. If reimplemented with a handler/looper threading model,
	the currently disabled stop button may be used.
	
	Andrew Schulze
*/

package com.example.helloandroid;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
//import android.util.Log; //enable if writing to log for debugging is desired

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import org.apache.http.*;
import org.apache.http.client.methods.HttpGet;

public class H2CarDisplay extends Activity {
	
//	public static final String LOG_TAG = "H2CarDisplay"; //enable if you want to write to the log for debugging purposes
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        final String url = "http://web.missouri.edu/~PAWPRINT/"; //change this URL to text file on server or change to your pawprint

        // This creates a new alert dialog used when there are errors
        final AlertDialog alertDialog = new AlertDialog.Builder(this).create();
        alertDialog.setButton("OK", new DialogInterface.OnClickListener() {
        	public void onClick(DialogInterface dialog, int which) {
        		dialog.cancel(); //closes dialog
        	}
        });
        
        // This references the stop button created in main.xml
        // Currently set up to not be available to the user as the stop functionality is not available within AsyncTask for another button
        final Button btnstop = (Button) findViewById(R.id.stop);
        btnstop.setVisibility(4); //set invisible
    	btnstop.setClickable(false); //turn off clickability
    	btnstop.setEnabled(false); //disable start button
    	
    	// The following code may be used to have an onclick for the stop button
    	/* btnstop.setOnClickListener(new OnClickListener() {
	        public void onClick(View v) {
	        	H2CarDisplay.this.finish(); //Kills H2CarDisplay process, results in unexpected force quit
	        	btnstop.setClickable(false); //turn off clickability of stop button again
	        	btnstop.setEnabled(false); //disable stop button
            }
        }); */
        
        // Create the start button to start updating
        final Button btnstart = (Button) findViewById(R.id.start);
        btnstart.setOnClickListener(new OnClickListener() {
            public void onClick(View v) {
            	
            	// Perform action on clicks
            	btnstart.setClickable(false); //unclickable to prevent another instance of this task
            	btnstart.setEnabled(false); //disable start button
            	
            	new RetrieveHTML().execute(url); //starts AsyncTask and passes the String url
            	
            	// The following code may be enabled if the stop button is implemented
            	/* //make stop button clickable
            	btnstop.setClickable(true);
            	btnstop.setEnabled(true); */
            }
            
            // Asynchronous Task created by Start button click
            final class RetrieveHTML extends AsyncTask<String, String, String[]> {
            	//dialog for displaying messages to the user
            	private ProgressDialog dialog = new ProgressDialog(H2CarDisplay.this);
            	
            	private String response; //will hold the string read from the webpage
            	private String[] splitstr = new String[4]; //the string split into tokens
            	Calendar cal = Calendar.getInstance(); //used to convert ms to a date time
            	int cnt = 0; //used if the while loop is used and to prevent a first iteration sleep
            	SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss.SSS");
            	TextView time = (TextView)findViewById(R.id.time); //references the time label
            	TextView speed = (TextView)findViewById(R.id.speed); //references the speed label
            	TextView fueleff = (TextView)findViewById(R.id.fueleff); //references the fuel efficiency label
            	TextView errorcode = (TextView)findViewById(R.id.errorcode); //references the error code label
            	
            	// Prior to doing background computations, still in UI thread
                protected void onPreExecute() {
                	dialog.setMessage("Retrieving HTTP data.."); //a message to the user
                	dialog.show();
                }
            	
            	protected String[] doInBackground(String... urls) {
            		final AndroidHttpClient client = AndroidHttpClient.newInstance("H2CarDisplay");
        		    final HttpGet getRequest = new HttpGet(urls[0]);
        		    try { 
//	        		    while(cnt < 6) //use if multiple server retrievals is desired, otherwise will do just one
//	        		    {
	        		    	if (cnt != 0) //assures execution does not sleep in first iteration
	        		    	{			  //used for Get while loop implementation
	        		    		SystemClock.sleep(5000);
	        		    	}
	        		    	publishProgress("5", "Retrieving HTTP data.."); //updates UI thread (necessary to display again when using while loop)
//	        		    	Log.d("RetrieveHTTP", "show retrieving http"); //for debugging purposes
	        		    
	        		        HttpResponse hresponse = client.execute(getRequest);
//	        		        Log.d("RetrieveHTTP", "past httpresonse"); //for debugging purposes
	        		        final int statusCode = hresponse.getStatusLine().getStatusCode();
//	        		        Log.d("RetrieveHTTP", "past status code"); //for debugging purposes
	        		        if (statusCode != HttpStatus.SC_OK) {  //status code is not OK
//	        		            Log.w("RetrieveHTTP", "Error " + statusCode + " while retrieving http from " + urls[0]); //for debugging purposes
	        		            publishProgress("0", "Error retrieving http stuff"); //send error update to UI
//	        		            break; //enable if while loop is enabled
	        		            return null; //otherwise use this to cancel execution if error is encountered
	        		        }
	        		        
	        		        final HttpEntity entity = hresponse.getEntity();
//	        		        Log.d("RetrieveHTTP", "past httpentity"); //for debugging purposes
	        		        if (entity != null) {
	        		        	BufferedReader in = null;
	        		            try {
	        		            	in = new BufferedReader(
	                                new InputStreamReader(entity.getContent())); 
	        		                response = in.readLine(); //reads in line from webpage
	
	                        		if (response == null) //makes sure there is content
	                        		{
	                        			publishProgress("0", "Error retrieving from server"); //send error to UI
//	                        			break; //enable if while loop is enabled
	    	        		            return null; //otherwise use this to cancel execution if error is encountered
	                        		}
	                        		else
	                        		{	
	                        			splitstr = response.split(","); //split the comment delimited string
	                        			
	            	            		if ((System.currentTimeMillis() - Long.valueOf(splitstr[0])) < 120000) //normal conditions
//	                        			if ((System.currentTimeMillis() - System.currentTimeMillis() - 1) < 120000) //testing purposes
	            	            		{
	            	            			publishProgress("1", splitstr[0]); //updates UI with time
	            	            			publishProgress("2", splitstr[1]); //updates UI with speed
	            	            			publishProgress("3", splitstr[2]); //updates UI with fuel efficiency
	            	            			publishProgress("4", splitstr[3]); //updates UI with error code
	            	            		}
	            	            		else
	            	            		{
	            	            			publishProgress("0", "Not updated within 2 min."); //send error to UI
//	            	            			break; //enable if while loop is enabled
	        	        		            return null; //otherwise use this to cancel execution if error is encountered
	            	            		}
	                        		}
	        		            } finally {
	        		                if (in != null) {
	        		                    in.close(); //close buffered reader
	        		                }
	        		                entity.consumeContent();
	        		            }
	        		        }
	        		        
	        		        cnt += 1; //increments counter used for a while loop and first iteration sleep
//	        		    }
        		    } catch (IOException e) { //used when cannot get a request from the server
	        		        getRequest.abort();
	        		        publishProgress("0", "Error retrieving from server"); //send error to UI
//	        		        Log.w("RetrieveHTTP", "Error" + urls[0], e); //for debugging purposes
	        		    } finally {
	        		        if (client != null) {
	        		            client.close(); //close the httpclient
	        		        }
	        		    }
        		    return null;
                }

            	// Allows access to the UI thread. Receives messages from doInBackground for updates.
            	protected void onProgressUpdate(String... str) {
            		int str0 = Integer.valueOf(str[0]); //contains conditional code that determines output
            		
					//Switch/Case statments are used because messages from background thread are sent as a string array containing:
						// str[0] message type identifier, str[1] string message
            		switch(str0)
            		{
            			case 0: //for errors, kills dialog, shows alert with message
            				dialog.dismiss(); //dimisses progress dialog
            				alertDialog.setMessage(str[1]); //sets error message to alert dialog
            				alertDialog.show();
            				break;
            			case 1: //updates time value textview
            				dialog.dismiss(); //dimisses progress dialog
            				cal.setTimeInMillis(Long.valueOf(str[1]));
                        	time.setText(formatter.format(cal.getTime()));
                        	break;
            			case 2: //updates speed textview
            				speed.setText(str[1]);
            				break;
            			case 3: //updates fuel efficiency textview
            				dialog.dismiss();
            				fueleff.setText(str[1]);
            				break;
            			case 4: //updates error code textview
            				errorcode.setText(str[1]);
            				break;
            			case 5: //reshows retrieving http
            				dialog.setMessage(str[1]);
            				dialog.show();
            				break;
            			default:
            				dialog.setMessage(str[1]);
            				break;
            		}
                }
            	
            	protected void onPostExecute(String[] str) {
            		btnstart.setClickable(true); //set start button to clickable again
            		btnstart.setEnabled(true); //enable start button
//            		btnstop.setClickable(false); //use these if stop button is implemented
//    	        	btnstop.setEnabled(false);
                 }
            }
        });
    }
}